% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/get_loo_fun.R
\name{get_loo_fun}
\alias{get_loo_fun}
\alias{get_loo_fun,tskrrHeterogeneous-method}
\alias{get_loo_fun,tskrrHomogeneous-method}
\alias{get_loo_fun,linearFilter-method}
\alias{get_loo_fun,character-method}
\alias{get_loo_fun,tskrrTune-method}
\title{Retrieve a loo function}
\usage{
get_loo_fun(x, ...)

\S4method{get_loo_fun}{tskrrHeterogeneous}(
  x,
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE
)

\S4method{get_loo_fun}{tskrrHomogeneous}(
  x,
  exclusion = c("edges", "vertices", "interaction", "both"),
  replaceby0 = FALSE
)

\S4method{get_loo_fun}{linearFilter}(x, replaceby0 = FALSE)

\S4method{get_loo_fun}{character}(
  x = c("tskrrHeterogeneous", "tskrrHomogeneous", "linearFilter"),
  ...
)

\S4method{get_loo_fun}{tskrrTune}(x, ...)
}
\arguments{
\item{x}{a character value with the class or a \code{\link{tskrr}}
or \code{\link{linearFilter}} object.}

\item{...}{arguments passed to or from other methods.}

\item{exclusion}{a character value with possible values "interaction",
"row", "column", "both" for heterogeneous models, and "edges", "vertices",
"interaction" or "both" for homogeneous models.
Defaults to "interaction". See details.}

\item{replaceby0}{a logical value indicating whether the interaction
should be simply removed (\code{FALSE}) or replaced by 0 (\code{TRUE}).}
}
\value{
a function taking the arguments y, and possibly pred
for calculating the leave-one-out cross-validation. For class
\code{tskrrHeterogeneous}, the returned function also
has an argument Hk and Hg, representing the hat matrix for the rows
and the columns respectively. For class \code{tskrrHomogeneous},
only the extra argument Hk is available. For class \code{linearFilter},
the extra argument is called \code{alpha} and takes the alpha vector
of that model.
}
\description{
This function returns the correct function needed to perform
one of the leave-one-out cross-validations. It's primarily meant
for internal use but can be useful when doing simulations.
}
\details{
This function can be used to select the correct loo function in
a simulation or tuning algorithm, based on the model object you
created. Depending on its class, the returned functions will have
different arguments, so you should only use this if you know
what you're doing and after you checked the actual returned
functions in \code{\link{loo_internal}}.

Using \code{replaceby0} only makes sense if you only remove the interaction.
In all other cases, this argument is ignored.

For the class \code{tskrrHomogeneous}, it doesn't make sense to
remove rows or columns. If you chose this option, the function will
throw an error. Removing edges corresponds to the setting "edges" or
"interaction". Removing vertices corresponds to the setting "vertices" or
"both". These terms can be used interchangeably.

For the class \code{linearFilter} it only makes sense to exclude the
interaction (i.e., a single cell). Therefore you do not have an argument
\code{exclusion} for that method.

For the classes \code{tskrrTune} and \code{tskrrImpute},
not specifying \code{exclusion} or \code{replaceby0} returns the used
loo function. If you specify either of them,
it will use the method for the appropriate model and return
a new loo function.
}
\seealso{
\code{\link{loo}} for carrying out a leave on out crossvalidation,
and \code{\link{loo_internal}} for more information on the internal
functions one retrieves with this one.
}
