% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerturbationImportance.R
\name{CFI}
\alias{CFI}
\title{Conditional Feature Importance}
\description{
Implementation of CFI using modular sampling approach
}
\details{
CFI replaces feature values with conditional samples from the distribution of
the feature given the other features. Any \link{ConditionalSampler} or \link{KnockoffSampler} can be used.
\subsection{Statistical Inference}{

Two approaches for statistical inference are primarily supported via
\verb{$importance(ci_method = "cpi")}:
\itemize{
\item \strong{CPI} (Watson & Wright, 2021): The original Conditional Predictive Impact method,
designed for use with knockoff samplers (\link{KnockoffGaussianSampler}).
\item \strong{cARFi} (Blesch et al., 2025): CFI with ARF-based conditional sampling
(\link{ConditionalARFSampler}), using the same CPI inference framework.
}

Both require a decomposable measure (e.g., MSE) and out-of-sample evaluation.
CPI inference is guaranteed to be valid with holdout (a single train/test split).
With cross-validation, test observations are i.i.d. but models are fit on
overlapping training data, which may affect inference coverage. With bootstrap
or subsampling, both non-i.i.d. test observations and overlapping training data
can be an issue. See \code{vignette("inference", package = "xplainfi")} for details.

Available tests: \code{"t"} (t-test), \code{"wilcoxon"} (signed-rank), \code{"fisher"} (permutation),
\code{"binomial"} (sign test). The Fisher test is recommended.

Method-agnostic inference methods (\code{"raw"}, \code{"nadeau_bengio"}, \code{"quantile"}) are also
available; see \link{FeatureImportanceMethod} for details.

For a comprehensive overview of inference methods including usage examples,
see \code{vignette("inference", package = "xplainfi")}.
}
}
\examples{
library(mlr3)

task <- sim_dgp_correlated(n = 200)

# Using default ConditionalARFSampler
cfi <- CFI$new(
  task = task,
  learner = lrn("regr.rpart"),
  measure = msr("regr.mse"),
  sampler = ConditionalGaussianSampler$new(task),
  n_repeats = 5
)
cfi$compute()
cfi$importance()
}
\references{
Watson D, Wright M (2021).
\dQuote{Testing Conditional Independence in Supervised Learning Algorithms.}
\emph{Machine Learning}, \bold{110}(8), 2107--2129.
\doi{10.1007/s10994-021-06030-6}.

Blesch K, Koenen N, Kapar J, Golchian P, Burk L, Loecher M, Wright M (2025).
\dQuote{Conditional Feature Importance with Generative Modeling Using Adversarial Random Forests.}
\emph{Proceedings of the AAAI Conference on Artificial Intelligence}, \bold{39}(15), 15596--15604.
\doi{10.1609/aaai.v39i15.33712}.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureImportanceMethod]{xplainfi::FeatureImportanceMethod}} -> \code{\link[xplainfi:PerturbationImportance]{xplainfi::PerturbationImportance}} -> \code{CFI}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFI-new}{\code{CFI$new()}}
\item \href{#method-CFI-compute}{\code{CFI$compute()}}
\item \href{#method-CFI-clone}{\code{CFI$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="obs_loss"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-obs_loss'><code>xplainfi::FeatureImportanceMethod$obs_loss()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="print"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-print'><code>xplainfi::FeatureImportanceMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="reset"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-reset'><code>xplainfi::FeatureImportanceMethod$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="scores"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-scores'><code>xplainfi::FeatureImportanceMethod$scores()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="PerturbationImportance" data-id="importance"><a href='../../xplainfi/html/PerturbationImportance.html#method-PerturbationImportance-importance'><code>xplainfi::PerturbationImportance$importance()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFI-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFI-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the CFI class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFI$new(
  task,
  learner,
  measure = NULL,
  resampling = NULL,
  features = NULL,
  groups = NULL,
  relation = "difference",
  n_repeats = 30L,
  batch_size = NULL,
  sampler = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task, learner, measure, resampling, features, groups, relation, n_repeats, batch_size}}{Passed to \link{PerturbationImportance}.}

\item{\code{sampler}}{(\link{ConditionalSampler}) Optional custom sampler. Defaults to instantiating \code{ConditionalARFSampler} internally with default parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFI-compute"></a>}}
\if{latex}{\out{\hypertarget{method-CFI-compute}{}}}
\subsection{Method \code{compute()}}{
Compute CFI scores
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFI$compute(
  n_repeats = NULL,
  batch_size = NULL,
  store_models = TRUE,
  store_backends = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_repeats}}{(\code{integer(1)}) Number of permutation iterations. If \code{NULL}, uses stored value.}

\item{\code{batch_size}}{(\code{integer(1)} | \code{NULL}: \code{NULL}) Maximum number of rows to predict at once. If \code{NULL}, uses stored value.}

\item{\code{store_models, store_backends}}{(\code{logical(1)}: \code{TRUE}) Whether to store fitted models / data backends, passed to \link[mlr3:resample]{mlr3::resample} internally
for the initial fit of the learner.
This may be required for certain measures and is recommended to leave enabled unless really necessary.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
