% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionalGaussianSampler.R
\name{ConditionalGaussianSampler}
\alias{ConditionalGaussianSampler}
\title{Gaussian Conditional Sampler}
\description{
Implements conditional sampling assuming features follow a multivariate
Gaussian distribution. Computes conditional distributions analytically using standard
formulas for multivariate normal distributions.
}
\details{
For a joint Gaussian distribution \eqn{X \sim N(\mu, \Sigma)}, partitioned as
\eqn{X = (X_A, X_B)}, the conditional distribution is:

\deqn{X_B | X_A = x_A \sim N(\mu_{B|A}, \Sigma_{B|A})}

where:
\deqn{\mu_{B|A} = \mu_B + \Sigma_{BA} \Sigma_{AA}^{-1} (x_A - \mu_A)}
\deqn{\Sigma_{B|A} = \Sigma_{BB} - \Sigma_{BA} \Sigma_{AA}^{-1} \Sigma_{AB}}

This is equivalent to the regression formulation used by fippy:
\deqn{\beta = \Sigma_{BA} \Sigma_{AA}^{-1}}
\deqn{\mu_{B|A} = \mu_B + \beta (x_A - \mu_A)}
\deqn{\Sigma_{B|A} = \Sigma_{BB} - \beta \Sigma_{AB}}

\strong{Assumptions:}
\itemize{
\item Features are approximately multivariate normal
\item Only continuous features are supported
}

\strong{Advantages:}
\itemize{
\item Very fast (closed-form solution)
\item Deterministic (given seed)
\item No hyperparameters
\item Memory efficient
}

\strong{Limitations:}
\itemize{
\item Strong distributional assumption
\item May produce out-of-range values for bounded features
\item Cannot handle categorical features
\item Integer features are treated as continuous and rounded back to integers
}
}
\examples{
library(mlr3)
task = tgen("friedman1")$generate(n = 100)
sampler = ConditionalGaussianSampler$new(task)

# Sample x2, x3 conditioned on x1
test_data = task$data(rows = 1:5)
sampled = sampler$sample_newdata(
  feature = c("important2", "important3"),
  newdata = test_data,
  conditioning_set = "important1"
)

}
\references{
Anderson T (2003).
\emph{An Introduction to Multivariate Statistical Analysis}, 3rd edition.
Wiley-Interscience, Hoboken, NJ.
ISBN 9780471360919.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{\link[xplainfi:ConditionalSampler]{xplainfi::ConditionalSampler}} -> \code{ConditionalGaussianSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature_types}}{(\code{character()}) Feature types supported by the sampler.}

\item{\code{mu}}{(\code{numeric()}) Mean vector estimated from training data.}

\item{\code{sigma}}{(\code{matrix()}) Covariance matrix estimated from training data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConditionalGaussianSampler-new}{\code{ConditionalGaussianSampler$new()}}
\item \href{#method-ConditionalGaussianSampler-clone}{\code{ConditionalGaussianSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="ConditionalSampler" data-id="sample"><a href='../../xplainfi/html/ConditionalSampler.html#method-ConditionalSampler-sample'><code>xplainfi::ConditionalSampler$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="ConditionalSampler" data-id="sample_newdata"><a href='../../xplainfi/html/ConditionalSampler.html#method-ConditionalSampler-sample_newdata'><code>xplainfi::ConditionalSampler$sample_newdata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalGaussianSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalGaussianSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ConditionalGaussianSampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalGaussianSampler$new(task, conditioning_set = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from. Must have only numeric/integer features.}

\item{\code{conditioning_set}}{(\code{character} | \code{NULL}) Default conditioning set to use in \verb{$sample()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalGaussianSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalGaussianSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalGaussianSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
