# Extracted from test-variance-estimation.R:333

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
task = sim_dgp_independent(n = 200)
pfi = PFI$new(
		task = task,
		learner = lrn("regr.rpart"),
		measure = msr("regr.mse"),
		resampling = rsmp("subsampling", repeats = 11),
		n_repeats = 3
	)
pfi$compute()
imp_none = pfi$importance(ci_method = "raw", alternative = "two.sided")
imp_bonf = pfi$importance(ci_method = "raw", alternative = "two.sided", p_adjust = "bonferroni")
expect_true(all(imp_bonf$p.value >= imp_none$p.value - 1e-10))
