% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{to_yamlet.list}
\alias{to_yamlet.list}
\title{Coerce list to yamlet Storage Format}
\usage{
\method{to_yamlet}{list}(x, ..., bracket_all = FALSE)
}
\arguments{
\item{x}{object}

\item{...}{ignored}

\item{bracket_all}{FALSE at top level, but TRUE recursively downward; supports 'ITEM: definition' which would otherwise be bracketted}
}
\value{
length-one character
}
\description{
Coerces list to yamlet storage format. Operates recursively on list members.
}
\examples{
to_yamlet(list())
to_yamlet(list(a = 1, b = 2, c = NULL))
to_yamlet(list(a = 1, b = list(c = 3, d = list(e = 4, f = 'g', 'h'))))
to_yamlet(setNames(1:3, c('a','b',NA)))
to_yamlet(setNames(c(1,2,NA), c('a','b','c')))

}
\seealso{
Other to_yamlet: 
\code{\link{to_yamlet}()},
\code{\link{to_yamlet.NULL}()},
\code{\link{to_yamlet.character}()},
\code{\link{to_yamlet.default}()},
\code{\link{to_yamlet.numeric}()},
\code{\link{to_yamlet.yamlet}()}
}
\concept{to_yamlet}
\keyword{internal}
