% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.rmd_doc}
\title{Update an rmd_doc}
\usage{
\method{update}{rmd_doc}(object, ...)
}
\arguments{
\item{object}{An object of class \code{rmd_doc}.}

\item{...}{Named arguments to be inserted in the YAML header (passed to
\code{\link[=write_rmd]{write_rmd()}}).}
}
\description{
Alternative to modify settings and content in \code{rmd_doc} objects. Note that to
skip some elements of the YAML header, you can set the argument NULL to the
respective parameter.
}
\examples{
## Create a document from a list
my_document <- list(
    title = "Sample Document",
    author = "Miguel Alavarez",
    output = "html_document",
    body = txt_body(
        "# Intro",
        "",
        "This is just an example."
    ))
my_document <- as(my_document, "rmd_doc")
my_document

## Change output format
my_document <- update(my_document, output = "pdf_document")
my_document
}
