% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{get_data}
\alias{get_data}
\title{Get Data from the Yahoo Finance API}
\usage{
get_data(payload = NULL)
}
\arguments{
\item{payload}{list. Payload that contains search criteria created using
the \code{\link{create_query}} and \code{\link{create_payload}} functions.}
}
\value{
A data frame that contains data from the Yahoo Finance API for the
specified search criteria.
}
\description{
A function to get data from the Yahoo Finance API using the specified payload.
}
\examples{
filters <- list(
  list("eq", list("region", "us")),
  list("btwn", list("intradaymarketcap", 2000000000, 10000000000)),
  list("btwn", list("intradaymarketcap", 10000000000, 100000000000)),
  list("gt", list("intradaymarketcap", 100000000000)),
  list("gt", list("dayvolume", 5000000))
)

query <- create_query(filters)

payload <- create_payload("equity", query)

\dontrun{
data <- get_data(payload)
}
}
