% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_bookdown.R
\name{yml_bookdown_opts}
\alias{yml_bookdown_opts}
\alias{yml_bookdown_site}
\title{Set Top-level YAML options for bookdown}
\usage{
yml_bookdown_opts(
  .yml,
  book_filename = yml_blank(),
  delete_merged_file = yml_blank(),
  before_chapter_script = yml_blank(),
  after_chapter_script = yml_blank(),
  edit = yml_blank(),
  history = yml_blank(),
  rmd_files = yml_blank(),
  rmd_subdir = yml_blank(),
  output_dir = yml_blank(),
  clean = yml_blank(),
  ...
)

yml_bookdown_site(.yml)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{book_filename}{A character vector, the filename of the main \code{.Rmd}
file, the \code{.Rmd} file that is created by merging all chapters. By default,
it is called "_main.Rmd".}

\item{delete_merged_file}{Logical. Delete the main \code{.Rmd} file if it exists?}

\item{before_chapter_script, after_chapter_script}{A character vector of one
or more R scripts to be executed before or after each chapter}

\item{edit}{A URL that collaborators can click to edit the \code{.Rmd} source
document of the current page, usually a link to a GitHub repository. This
link should have \verb{\%s} where the actual \code{.Rmd} filename for each page will
go.}

\item{history}{Similar to \code{edit}, a link to the edit/commit history of the
current page.}

\item{rmd_files}{A character vector, the order order of \code{.Rmd} files for the
book. \code{rmd_files} can also be a named list where each element of the list
is named for the output type, e.g. "html" or "latex". By default, bookdown
merges all \code{.Rmd} files by the order of filenames.}

\item{rmd_subdir}{whether to search for book source \code{.Rmd} files in
subdirectories (by default, only the root directory is searched). This may
be either a boolean (e.g. \code{TRUE} will search for book source \code{.Rmd} files
in the project directory and all subdirectories) or vector of paths if you
want to search for book source \code{.Rmd} files in a subset of subdirectories.}

\item{output_dir}{the output directory of the book ("_book" by default)}

\item{clean}{a character vector of files and directories to be cleaned by the
\code{bookdown::clean_book()} function.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a \code{yml} object
}
\description{
bookdown uses YAML in three main places, as described in the \href{https://yihui.org/rmarkdown/bookdown-project.html}{bookdown book}:
\code{index.Rmd}, \verb{_output.yml}, and \verb{_bookdown.yml}. \code{index.Rmd} can take most
YAML. \verb{_output.yml} is intended for output-related YAML, such as that
produced by \code{yml() \%>\% yml_output(bookdown::pdf_book())}. \verb{_bookdown.yml} is
intended for configuring the build of the book. Pass the results of the
\verb{yml_*()} functions to \code{use_index_rmd()}, \code{use_bookdown_yml()},
\code{use_output_yml()} to write them to these files. \code{yml_bookdown_site()} adds
the \code{site: "bookdown::bookdown_site"} to the YAML metadata.
}
\examples{

yml_empty() \%>\%
  yml_bookdown_opts(
    book_filename = "my-book.Rmd",
    before_chapter_script = c("script1.R", "script2.R"),
    after_chapter_script = "script3.R",
    edit = "https =//github.com/rstudio/bookdown-demo/edit/master/\%s",
    output_dir = "book-output",
    clean = c("my-book.bbl", "R-packages.bib")
 )

yml_empty() \%>\%
  yml_bookdown_opts(
    rmd_files = list(
      html = c("index.Rmd", "abstract.Rmd", "intro.Rmd"),
      latex = c("abstract.Rmd", "intro.Rmd")
    )
 )

 x <- yml_empty() \%>\%
  yml_title("A Minimal Book Example") \%>\%
  yml_date(yml_code(Sys.Date())) \%>\%
  yml_author("Yihui Xie") \%>\%
  yml_bookdown_site() \%>\%
  yml_latex_opts(
    documentclass = "book",
    bibliography = c("book.bib", "packages.bib"),
    biblio_style = "apalike"
  ) \%>\%
  yml_citations(
    link_citations = TRUE
  ) \%>\%
  yml_description("This is a minimal example of using
  the bookdown package to write a book.")

x


\donttest{
output_yml <- yml_empty() \%>\%
  yml_output(
    bookdown::gitbook(
      lib_dir = "assets",
      split_by = "section",
      config = gitbook_config(toolbar_position = "static")
    ),
    bookdown::pdf_book(keep_tex = TRUE),
    bookdown::html_book(css = "toc.css")
  )
output_yml
}


}
\seealso{
\code{\link[=use_index_rmd]{use_index_rmd()}} \code{\link[=use_bookdown_yml]{use_bookdown_yml()}} \code{\link[=use_output_yml]{use_output_yml()}}

Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}

Other bookdown: 
\code{\link{gitbook_config}()}
}
\concept{bookdown}
\concept{yml}
