% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\encoding{UTF-8}
\name{categories}
\alias{categories}
\alias{z22_categories}
\title{Feature categories}
\usage{
z22_categories(feature)
}
\arguments{
\item{feature}{A grid feature. See \code{\link{z22_features}} for a list
of available features. If a feature is provided that does not have
categories, generates a table based on the feature description.}
}
\value{
A tibble containing the category code (\code{code}) as well as
German and English labels (\code{german} and \code{english}). Each row
relates to a category of a feature.
}
\description{
While some features contain total counts or averages, others contain figures
classified by certain categories. You can access these tables
programmatically using \code{z22_categories}.

For further clarification of terms used in the category labels, see
the \link{glossary}.
}
\examples{
z22_categories("sex")

# Features without categories are given code 0
z22_categories("families")
}
\section{Categories}{
\describe{
  \item{\code{birth_country}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Deutschland \tab Germany     \cr
    		20 \tab Ausland     \tab Foreign     \cr
    		21 \tab EU27-Land   \tab EU27 country\cr
    		22 \tab Europa      \tab Europe      \cr
    		23 \tab Welt        \tab World       \cr
    		24 \tab Sonstige    \tab Other       
		}
}

\enc{}{}
  \item{\code{sex}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Männlich \tab Male  \cr
    		2 \tab Weiblich \tab Female
		}
}

\enc{}{}
  \item{\code{religion}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Römisch-katholische Kirche   \tab Roman Catholic Church      \cr
    		2 \tab Evangelische Kirche          \tab Evangelical Church         \cr
    		3 \tab Sonstige, keine, ohne Angabe \tab Other, none, no information
		}
}

\enc{}{}
  \item{\code{citizenship}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Deutschland \tab Germany\cr
    		2 \tab Ausland     \tab Foreign
		}
}

\enc{}{}
  \item{\code{citizenship_group}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Deutschland      \tab Germany     \cr
    		20 \tab Ausland          \tab Foreign     \cr
    		21 \tab EU27-Land        \tab EU27 Country\cr
    		22 \tab Sonstiges Europa \tab Other Europe\cr
    		23 \tab Sonstige Welt    \tab Other World \cr
    		24 \tab Sonstige         \tab Other       
		}
}

\enc{}{}
  \item{\code{citizenship_origin}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Deutschland             \tab Germany               \cr
    		 2 \tab Bosnien und Herzegowina \tab Bosnia and Herzegovina\cr
    		 3 \tab Griechenland            \tab Greece                \cr
    		 4 \tab Italien                 \tab Italy                 \cr
    		 5 \tab Kasachstan              \tab Kazakhstan            \cr
    		 6 \tab Kroatien                \tab Croatia               \cr
    		 7 \tab Niederlande             \tab Netherlands           \cr
    		 8 \tab Österreich              \tab Austria               \cr
    		 9 \tab Polen                   \tab Poland                \cr
    		10 \tab Rumänien                \tab Romania               \cr
    		11 \tab Russische Föderation    \tab Russian Federation    \cr
    		12 \tab Türkei                  \tab Turkey                \cr
    		13 \tab Ukraine                 \tab Ukraine               \cr
    		14 \tab Sonstige                \tab Other                 
		}
}

\enc{}{}
  \item{\code{citizenship_total}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Eine Staatsangehörigkeit  \tab One citizenship        \cr
    		2 \tab Mehrere, deutsch und ...  \tab Several, German and ...\cr
    		3 \tab Mehrere, nur ausländische \tab Several, only foreign  \cr
    		4 \tab Nicht bekannt             \tab Unknown                
		}
}

\enc{}{}
  \item{\code{age_short}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Unter 18     \tab Under 18    \cr
    		2 \tab 18 - 29      \tab 18 to 29    \cr
    		3 \tab 30 - 49      \tab 30 to 49    \cr
    		4 \tab 50 - 64      \tab 50 to 64    \cr
    		5 \tab 65 und älter \tab 65 and older
		}
}

\enc{}{}
  \item{\code{age_long}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Unter 10     \tab Under 10    \cr
    		2 \tab 10 - 19      \tab 10 to 19    \cr
    		3 \tab 20 - 29      \tab 20 to 29    \cr
    		4 \tab 30 - 39      \tab 30 to 39    \cr
    		5 \tab 40 - 49      \tab 40 to 49    \cr
    		6 \tab 50 - 59      \tab 50 to 59    \cr
    		7 \tab 60 - 69      \tab 60 to 69    \cr
    		8 \tab 70 - 79      \tab 70 to 79    \cr
    		9 \tab 80 und älter \tab 80 and older
		}
}

\enc{}{}
  \item{\code{marital_status}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Ledig                                   \tab Single                         \cr
    		2 \tab Verheiratet                             \tab Married                        \cr
    		3 \tab Verwitwet                               \tab Widowed                        \cr
    		4 \tab Geschieden                              \tab Divorced                       \cr
    		5 \tab Eingetr. Lebenspartnerschaft            \tab Registered partnership         \cr
    		6 \tab Eingetr. Lebenspartner/-in verstorben   \tab Registered partner deceased    \cr
    		7 \tab Eingetr. Lebenspartnerschaft aufgehoben \tab Registered partnership annulled\cr
    		8 \tab Ohne Angabe                             \tab No information                 
		}
}

\enc{}{}
  \item{\code{family_type}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Ehepaare ohne Kind                               \tab Couples without child                               \cr
    		 2 \tab Ehepaare, mind. 1 Kind < 18                      \tab Couples, at least 1 child < 18                      \cr
    		 3 \tab Ehepaare alle Kinder >= 18                        \tab Couples all children >= 18                           \cr
    		 4 \tab Eingetr. Lebenspartnerschaften ohne Kind         \tab Registered civil partnerships without child         \cr
    		 5 \tab Eingetr. Lebenspartnerschaften mind. 1 Kind < 18 \tab Registered civil partnerships, at least 1 child < 18\cr
    		 6 \tab Eingetr. Lebenspartnerschaften alle Kinder >= 18  \tab Registered civil partnerships all children >= 18     \cr
    		 7 \tab Nichteheliche Lebensgem. ohne Kind               \tab Non-marital partnerships without child              \cr
    		 8 \tab Nichteheliche Lebensgem. mind. 1 Kind < 18       \tab Non-marital partnerships, at least 1 child < 18     \cr
    		 9 \tab Nichteheliche Lebensgem. alle Kinder >= 18        \tab Non-marital partnerships all children >= 18          \cr
    		10 \tab Alleinerziehende Väter mind. 1 Kind < 18         \tab Single fathers, at least 1 child < 18               \cr
    		11 \tab Alleinerziehende Väter alle Kinder >= 18          \tab Single fathers all children >= 18                    \cr
    		12 \tab Alleinerziehende Mütter mind. 1 Kind < 18        \tab Single mothers, at least 1 child < 18               \cr
    		13 \tab Alleinerziehende Mütter alle Kinder >= 18         \tab Single mothers all children >= 18                    
		}
}

\enc{}{}
  \item{\code{family_size}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab 2 Personen          \tab 2 Persons         \cr
    		2 \tab 3 Personen          \tab 3 Persons         \cr
    		3 \tab 4 Personen          \tab 4 Persons         \cr
    		4 \tab 5 Personen          \tab 5 Persons         \cr
    		5 \tab 6 und mehr Personen \tab 6 and more Persons
		}
}

\enc{}{}
  \item{\code{household_family}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Einpersonenhaushalte (Singlehaushalte) \tab One-person households (Single households)  \cr
    		2 \tab Paare ohne Kind(er)                    \tab Couples without child(ren)                 \cr
    		3 \tab Paare mit Kind(ern)                    \tab Couples with child(ren)                    \cr
    		4 \tab Alleinerziehende Elternteile           \tab Single parents                             \cr
    		5 \tab Mehrpersonenhaushalte ohne Kernfamilie \tab Multi-person households without core family
		}
}

\enc{}{}
  \item{\code{household_lifestyle}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Einpersonenhaushalte (Singlehaushalte) \tab One-person households (Single households)  \cr
    		2 \tab Ehepaare                               \tab Married couples                            \cr
    		3 \tab Eingetr. Lebenspartnerschaften         \tab Registered civil partnerships              \cr
    		4 \tab Nichteheliche Lebensgemeinschaften     \tab Non-marital partnerships                   \cr
    		5 \tab Alleinerziehende Mütter                \tab Single mothers                             \cr
    		6 \tab Alleinerziehende Väter                 \tab Single fathers                             \cr
    		7 \tab Mehrpersonenhaushalte ohne Kernfamilie \tab Multi-person households without core family
		}
}

\enc{}{}
  \item{\code{household_senior}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Haushalte mit ausschließlich Senioren/-innen \tab Households with only seniors              \cr
    		2 \tab Haushalte mit Senioren/-innen und Jüngeren   \tab Households with seniors and younger people\cr
    		3 \tab Haushalte ohne Senioren/-innen               \tab Households without seniors                
		}
}

\enc{}{}
  \item{\code{household_size_group}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab 1 Person            \tab 1 Person          \cr
    		2 \tab 2 Personen          \tab 2 Persons         \cr
    		3 \tab 3 Personen          \tab 3 Persons         \cr
    		4 \tab 4 Personen          \tab 4 Persons         \cr
    		5 \tab 5 Personen          \tab 5 Persons         \cr
    		6 \tab 6 und mehr Personen \tab 6 and more Persons
		}
}

\enc{}{}
  \item{\code{dwelling_occupancy}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Von Eigentümer/-in bewohnt                 \tab Occupied by owner                             \cr
    		11 \tab Eigentum: mit aktuell geführtem Haushalt   \tab Ownership: with currently managed household   \cr
    		12 \tab Eigentum: ohne aktuell geführtem Haushalt  \tab Ownership: without currently managed household\cr
    		 2 \tab Zu Wohnzwecken vermietet                   \tab Rented for residential purposes               \cr
    		21 \tab Vermietet: mit aktuell geführtem Haushalt  \tab Rented: with currently managed household      \cr
    		22 \tab Vermietet: ohne aktuell geführtem Haushalt \tab Rented: without currently managed household   \cr
    		 3 \tab Ferien- und Freizeitwohnung                \tab Holiday and leisure home                      \cr
    		 4 \tab Leer stehend                               \tab Vacant                                        \cr
    		 5 \tab Diplomaten-/Streitkräftewohnung            \tab Diplomatic/Military housing                   \cr
    		99 \tab Gewerbl. Nutzung                           \tab Commercial use                                
		}
}

\enc{}{}
  \item{\code{dwelling_ownership_home}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Privatperson/-en                                  \tab Private person(s)                       \cr
    		 2 \tab Privatwirtschaftliche Unternehmen (jur. Personen) \tab Private sector companies (legal persons)\cr
    		 3 \tab Öffentliche Unternehmen, Kirchen o.ä.             \tab Public companies, churches or similar   \cr
    		 4 \tab Wohnungsgenossenschaft                            \tab Housing cooperative                     \cr
    		99 \tab Trifft nicht zu (da keine Eigentumswohnung)       \tab Does not apply (no condominium)         
		}
}

\enc{}{}
  \item{\code{dwelling_ownership_property}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Gemeinschaft von Wohnungseigentümern/-innen  \tab Homeowner association                    \cr
    		2 \tab Privatperson/-en                             \tab Private person(s)                        \cr
    		3 \tab Wohnungsgenossenschaft                       \tab Housing cooperative                      \cr
    		4 \tab Kommune oder Kommunales Wohnungsunternehmen  \tab Municipality or municipal housing company\cr
    		5 \tab Privatwirtschaftliches Wohnungsunternehmen   \tab Private sector housing company           \cr
    		6 \tab Anderes privatwirtschaftliches Unternehmen   \tab Other private sector company             \cr
    		7 \tab Bund oder Land                               \tab Federal or state government              \cr
    		8 \tab Organisation ohne Erwerbszweck (z.B. Kirche) \tab Non-profit organization (e.g. church)    
		}
}

\enc{}{}
  \item{\code{floor_space}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Unter 30           \tab Under 30        \cr
    		 2 \tab 30 - 39            \tab 30 - 39         \cr
    		 3 \tab 40 - 49            \tab 40 - 49         \cr
    		 4 \tab 50 - 59            \tab 50 - 59         \cr
    		 5 \tab 60 - 69            \tab 60 - 69         \cr
    		 6 \tab 70 - 79            \tab 70 - 79         \cr
    		 7 \tab 80 - 89            \tab 80 - 89         \cr
    		 8 \tab 90 - 99            \tab 90 - 99         \cr
    		 9 \tab 100 - 109          \tab 100 - 109       \cr
    		10 \tab 110 - 119          \tab 110 - 119       \cr
    		11 \tab 120 - 129          \tab 120 - 129       \cr
    		12 \tab 130 - 139          \tab 130 - 139       \cr
    		13 \tab 140 - 149          \tab 140 - 149       \cr
    		14 \tab 150 - 159          \tab 150 - 159       \cr
    		15 \tab 160 - 169          \tab 160 - 169       \cr
    		16 \tab 170 - 179          \tab 170 - 179       \cr
    		17 \tab 180 und mehr       \tab 180 and more    \cr
    		99 \tab t.n.z., gewerblich \tab n.a., commercial
		}
}

\enc{}{}
  \item{\code{dwelling_rooms}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab 1 Raum             \tab 1 Room          \cr
    		 2 \tab 2 Räume            \tab 2 Rooms         \cr
    		 3 \tab 3 Räume            \tab 3 Rooms         \cr
    		 4 \tab 4 Räume            \tab 4 Rooms         \cr
    		 5 \tab 5 Räume            \tab 5 Rooms         \cr
    		 6 \tab 6 Räume            \tab 6 Rooms         \cr
    		 7 \tab 7 und mehr Räume   \tab 7 and more Rooms\cr
    		99 \tab t.n.z., gewerblich \tab n.a., commercial
		}
}

\enc{}{}
  \item{\code{dwelling_constr_year}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Vor 1919        \tab Before 1919   \cr
    		 2 \tab 1919 - 1948     \tab 1919 - 1948   \cr
    		 3 \tab 1949 - 1978     \tab 1949 - 1978   \cr
    		 4 \tab 1979 - 1986     \tab 1979 - 1986   \cr
    		 5 \tab 1987 - 1990     \tab 1987 - 1990   \cr
    		 6 \tab 1991 - 1995     \tab 1991 - 1995   \cr
    		 7 \tab 1996 - 2000     \tab 1996 - 2000   \cr
    		 8 \tab 2001 - 2004     \tab 2001 - 2004   \cr
    		 9 \tab 2005 - 2008     \tab 2005 - 2008   \cr
    		10 \tab 2009 und später \tab 2009 and later
		}
}

\enc{}{}
  \item{\code{dwelling_building_type}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		  1 \tab Gebäude mit Wohnraum           \tab Building with living space                  \cr
    		 11 \tab Wohngebäude                    \tab Residential building                        \cr
    		111 \tab Wohngebäude (ohne Wohnheime)   \tab Residential building (excluding dormitories)\cr
    		112 \tab Wohnheim                       \tab Dormitory                                   \cr
    		 12 \tab Sonstiges Gebäude mit Wohnraum \tab Other building with living space            
		}
}

\enc{}{}
  \item{\code{dwelling_building_design}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Freistehendes Haus \tab Detached house     \cr
    		2 \tab Doppelhaus Hälfte  \tab Semi-detached house\cr
    		3 \tab Gereihtes Haus     \tab Terraced house     \cr
    		4 \tab Anderer Gebäudetyp \tab Other building type
		}
}

\enc{}{}
  \item{\code{dwelling_building_size}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Freistehendes Einfamilienhaus           \tab Detached single-family house              \cr
    		 2 \tab Einfamilienhaus: Doppelhaushälfte       \tab Single-family house: semi-detached        \cr
    		 3 \tab Einfamilienhaus: Reihenhaus             \tab Single-family house: terraced             \cr
    		 4 \tab Freistehendes Zweifamilienhaus          \tab Detached two-family house                 \cr
    		 5 \tab Zweifamilienhaus: Doppelhaushälfte      \tab Two-family house: semi-detached           \cr
    		 6 \tab Zweifamilienhaus: Reihenhaus            \tab Two-family house: terraced                \cr
    		 7 \tab Mehrfamilienhaus: 3-6 Wohnungen         \tab Multi-family house: 3-6 apartments        \cr
    		 8 \tab Mehrfamilienhaus: 7-12 Wohnungen        \tab Multi-family house: 7-12 apartments       \cr
    		 9 \tab Mehrfamilienhaus: 13 und mehr Wohnungen \tab Multi-family house: 13 and more apartments\cr
    		10 \tab Anderer Gebäudetyp                      \tab Other building type                       
		}
}

\enc{}{}
  \item{\code{dwelling_heat_type}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Fernheizung (Fernwärme)                          \tab District heating (long-distance heating)                      \cr
    		2 \tab Etagenheizung                                    \tab Self-contained central heating                                \cr
    		3 \tab Blockheizung                                     \tab Block heating                                                 \cr
    		4 \tab Zentralheizung                                   \tab Central heating                                               \cr
    		5 \tab Einzel-/Mehrraumöfen (auch Nachtspeicherheizung) \tab Individual/multi-room stoves (including night storage heating)\cr
    		6 \tab Keine Heizung im Gebäude oder in den Wohnungen   \tab No heating in the building or in the apartments               
		}
}

\enc{}{}
  \item{\code{dwelling_heat_src}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Gas                            \tab Gas                             \cr
    		2 \tab Heizöl                         \tab Heating oil                     \cr
    		3 \tab Holz(pellets)                  \tab Wood (pellets)                  \cr
    		4 \tab Biomasse (ohne Holz), Biogas   \tab Biomass (no wood), biogas       \cr
    		5 \tab Solar-/Geothermie, Wärmepumpen \tab Solar, geothermal, heat pumps   \cr
    		6 \tab Strom (ohne Wärmepumpen)       \tab Electric heating (no heat pumps)\cr
    		7 \tab Kohle                          \tab Coal                            \cr
    		8 \tab Fernwärme                      \tab District heating                \cr
    		9 \tab Kein Energieträger             \tab No heating                      
		}
}

\enc{}{}
  \item{\code{building_ownership_property}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Gemeinschaft von Wohnungseigentümern/-innen  \tab Homeowner association                    \cr
    		2 \tab Privatperson/-en                             \tab Private person(s)                        \cr
    		3 \tab Wohnungsgenossenschaft                       \tab Housing cooperative                      \cr
    		4 \tab Kommune oder Kommunales Wohnungsunternehmen  \tab Municipality or municipal housing company\cr
    		5 \tab Privatwirtschaftliches Wohnungsunternehmen   \tab Private sector housing company           \cr
    		6 \tab Anderes privatwirtschaftliches Unternehmen   \tab Other private sector company             \cr
    		7 \tab Bund oder Land                               \tab Federal or state government              \cr
    		8 \tab Organisation ohne Erwerbszweck (z.B. Kirche) \tab Non-profit organization (e.g. church)    
		}
}

\enc{}{}
  \item{\code{building_constr_year}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Vor 1919        \tab Before 1919   \cr
    		 2 \tab 1919 - 1948     \tab 1919 - 1948   \cr
    		 3 \tab 1949 - 1978     \tab 1949 - 1978   \cr
    		 4 \tab 1979 - 1986     \tab 1979 - 1986   \cr
    		 5 \tab 1987 - 1990     \tab 1987 - 1990   \cr
    		 6 \tab 1991 - 1995     \tab 1991 - 1995   \cr
    		 7 \tab 1996 - 2000     \tab 1996 - 2000   \cr
    		 8 \tab 2001 - 2004     \tab 2001 - 2004   \cr
    		 9 \tab 2005 - 2008     \tab 2005 - 2008   \cr
    		10 \tab 2009 und später \tab 2009 and later
		}
}

\enc{}{}
  \item{\code{building_dwellings}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab 1 Wohnung             \tab 1 Apartment           \cr
    		2 \tab 2 Wohnungen           \tab 2 Apartments          \cr
    		3 \tab 3 - 6 Wohnungen       \tab 3 - 6 Apartments      \cr
    		4 \tab 7 - 12 Wohnungen      \tab 7 - 12 Apartments     \cr
    		5 \tab 13 und mehr Wohnungen \tab 13 and more Apartments
		}
}

\enc{}{}
  \item{\code{building_size}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		 1 \tab Freistehendes Einfamilienhaus           \tab Detached single-family house              \cr
    		 2 \tab Einfamilienhaus: Doppelhaushälfte       \tab Single-family house: semi-detached        \cr
    		 3 \tab Einfamilienhaus: Reihenhaus             \tab Single-family house: terraced             \cr
    		 4 \tab Freistehendes Zweifamilienhaus          \tab Detached two-family house                 \cr
    		 5 \tab Zweifamilienhaus: Doppelhaushälfte      \tab Two-family house: semi-detached           \cr
    		 6 \tab Zweifamilienhaus: Reihenhaus            \tab Two-family house: terraced                \cr
    		 7 \tab Mehrfamilienhaus: 3-6 Wohnungen         \tab Multi-family house: 3-6 apartments        \cr
    		 8 \tab Mehrfamilienhaus: 7-12 Wohnungen        \tab Multi-family house: 7-12 apartments       \cr
    		 9 \tab Mehrfamilienhaus: 13 und mehr Wohnungen \tab Multi-family house: 13 and more apartments\cr
    		10 \tab Anderer Gebäudetyp                      \tab Other building type                       
		}
}

\enc{}{}
  \item{\code{building_type}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		  1 \tab Gebäude mit Wohnraum           \tab Building with living space                  \cr
    		 11 \tab Wohngebäude                    \tab Residential building                        \cr
    		111 \tab Wohngebäude (ohne Wohnheime)   \tab Residential building (excluding dormitories)\cr
    		112 \tab Wohnheim                       \tab Dormitory                                   \cr
    		 12 \tab Sonstiges Gebäude mit Wohnraum \tab Other building with living space            
		}
}

\enc{}{}
  \item{\code{building_design}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Freistehendes Haus \tab Detached house     \cr
    		2 \tab Doppelhaus Hälfte  \tab Semi-detached house\cr
    		3 \tab Gereihtes Haus     \tab Terraced house     \cr
    		4 \tab Anderer Gebäudetyp \tab Other building type
		}
}

\enc{}{}
  \item{\code{building_heat_type}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Fernheizung (Fernwärme)                          \tab District heating (long-distance heating)                      \cr
    		2 \tab Etagenheizung                                    \tab Self-contained central heating                                \cr
    		3 \tab Blockheizung                                     \tab Block heating                                                 \cr
    		4 \tab Zentralheizung                                   \tab Central heating                                               \cr
    		5 \tab Einzel-/Mehrraumöfen (auch Nachtspeicherheizung) \tab Individual/multi-room stoves (including night storage heating)\cr
    		6 \tab Keine Heizung im Gebäude oder in den Wohnungen   \tab No heating in the building or in the apartments               
		}
}

\enc{}{}
  \item{\code{building_heat_src}}{
		\tabular{rll}{
    		\strong{code} \tab \strong{german} \tab \strong{english}\cr
    		1 \tab Gas                            \tab Gas                             \cr
    		2 \tab Heizöl                         \tab Heating oil                     \cr
    		3 \tab Holz(pellets)                  \tab Wood (pellets)                  \cr
    		4 \tab Biomasse (ohne Holz), Biogas   \tab Biomass (no wood), biogas       \cr
    		5 \tab Solar-/Geothermie, Wärmepumpen \tab Solar, geothermal, heat pumps   \cr
    		6 \tab Strom (ohne Wärmepumpen)       \tab Electric heating (no heat pumps)\cr
    		7 \tab Kohle                          \tab Coal                            \cr
    		8 \tab Fernwärme                      \tab District heating                \cr
    		9 \tab Kein Energieträger             \tab No heating                      
		}
}


}}
