
use crate::Error;
use core::{ffi::c_void, mem::MaybeUninit};



extern "C" {
    
    
    
    
    
    fn CCRandomGenerateBytes(bytes: *mut c_void, size: usize) -> i32;
}

pub fn getrandom_inner(dest: &mut [MaybeUninit<u8>]) -> Result<(), Error> {
    let ret = unsafe { CCRandomGenerateBytes(dest.as_mut_ptr() as *mut c_void, dest.len()) };
    
    if ret != 0 {
        Err(Error::IOS_SEC_RANDOM)
    } else {
        Ok(())
    }
}
