% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{grid_search_check}
\alias{grid_search_check}
\title{Check the time consumed by running the grid search algorithm with a zoom.}
\usage{
grid_search_check(
  FUN,
  grid,
  MoreArgs = NULL,
  zoom = 0,
  decay = 0.5,
  num = 1,
  parallel = FALSE,
  cores = NULL,
  silent = TRUE
)
}
\arguments{
\item{FUN}{the target function to be minimized.}

\item{grid}{an object of class \code{GRID} created by \code{\link{build_grid}}.}

\item{MoreArgs}{a named list of additional arguments to \code{FUN}, see \code{\link{mapply}}.}

\item{zoom}{number of (additional) zoom-in layers, \code{0} by default.}

\item{decay}{a number in \eqn{(0,1)} controlling the decay of subgrid sizes.}

\item{num}{number of points to return at each grid search, \code{1} by default.}

\item{parallel}{a logical; if \code{TRUE}, parallel computation is used.}

\item{cores}{an integer specifying the requested number of workers when \code{parallel = TRUE}.
If \code{NULL}, the function uses \code{2} workers by default (subject to \code{future::availableCores()}).
The number of workers used is \code{min(cores, future::availableCores())}.}

\item{silent}{a logical indicating whether progress information is printed.}
}
\value{
a numeric value giving the estimated runtime in seconds.
}
\description{
This function provides a quick runtime estimate for \code{\link{grid_search}} under the same settings.
It performs two short pilot runs on smaller grids (with \code{zoom = 0}) and extrapolates the expected
time for the full grid and the requested number of zoom-in layers.
}
\details{
This is useful before launching a large run, for example on a compute server or under a batch system
such as SLURM, where an approximate runtime is needed to request resources.

The boolean \code{silent} controls whether progress information is printed to the console.
For details on the algorithm and the meaning of the arguments, see \code{\link{grid_search}}.
}
\examples{
# Rastrigin function
ndim <- 2
nA <- 10
Rastrigin <- function(vx) nA * ndim + sum(vx * vx - nA * cos(2 * pi * vx))

# Build a grid
bin <- c(from = -5.12, to = 5.12, by = .5)
grid <- build_grid(bin, bin)

# Estimate runtime (serial)
t_est <- grid_search_check(Rastrigin, grid, silent = FALSE)
t_est

\donttest{
# Finer grid
bin <- c(from = -5.12, to = 5.12, by = .1)
grid <- build_grid(bin, bin)

# Estimate runtime, then run the search
t_est <- grid_search_check(Rastrigin, grid, parallel = TRUE, cores = 2, silent = FALSE)
ret   <- grid_search(Rastrigin, grid, parallel = TRUE, cores = 2, silent = FALSE)
}

}
\seealso{
\code{\link{build_grid}}, \code{\link{grid_search}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{algorithms}
