% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztils.R
\name{multicdf_cont}
\alias{multicdf_cont}
\title{Multiple Cumulative Distribution Functions for Continuous Variables}
\usage{
multicdf_cont(var, seq_length = 50, distributions = "all")
}
\arguments{
\item{var}{The variable of which to get the CDF}

\item{seq_length}{The length of sequence to fit the distribution to}

\item{distributions}{The distributions to fit x against}
}
\value{
A dataframe with x, the real density, and the pdf of the desired
distributions with length (nrows) equal to seq_length +1.
}
\description{
This function gets the cumulative distribution function for
selected distributions against a continuous, non-negative input variable.
Possible distributions include "normal",
"lognormal", "gamma", "exponential", "cauchy", "t", "weibull", "logistic",
and "all".
}
\examples{
multicdf_cont(iris$Petal.Length)

multicdf_cont(iris$Sepal.Length,
              100,
              c("normal", "lognormal")
              )
}
